import numpy as np
import math
import string
def index(array,M,m):
    for i in range(M):
        if array[i]==m:
            return i
    return M
def encode(num,bit):
    num_str = bin(num)[2:]
    length = len(num_str)
    ans = []
    for i in range(bit-length):
        ans.append(0)
    for string in num_str:
        ans.append(int(string))
    return ans
def decode(C):
    length=np.shape(C)[0]
    c=0
    for i in range(length):
        if C[i]==1:
            c=c+(2)**(length-i-1)
    return c
def collision_indicator(j,arm_preference,pull,M):
    C=0
    arm=pull[j]
    for i in range(M):
        if pull[i]==arm:
            #if (arm_preference[arm,:]).index(i)<(arm_preference[arm,:].tolist()).index(j):
            if index(arm_preference[arm,:],M,i)< index(arm_preference[arm,:],M,j):
                C=1
    return C
def index_assignment(arm_preference,M,K,information,t_total,t_total_collision):
    inf=information
    pull=np.zeros(M,int)
    arm=np.zeros(M,int)
    t_0=0
    for i in range(K):
        t_0=t_total_collision[0,i]+t_0
    for k in range(K):
        for t in range(M):
            for m in range (M):
                pull[m]=arm[m]
            for i in range (M):
                t_total[i,pull[i]]=t_total[i,pull[i]]+1*(1-collision_indicator(i, arm_preference, pull, M))
                t_total_collision[i,pull[i]]=t_total_collision[i,pull[i]]+1
                if pull[i]==k:
                  collision = collision_indicator(i, arm_preference, pull, M)
                  if collision==0:
                    arm[i]=(arm[i]+1)%(K)
                    inf[i,k,t]=i
    return inf,t_total,t_total_collision
def information_exchange(k1, k2, k, arm_preference, K, M,information,t_total,t_total_collision):
    pull=np.zeros(M,int)
    log_m=math.ceil(math.log(M,2))
    for k3 in range(K):
        for k4 in range(M):
            C=np.zeros((log_m),int)
            for k5 in range(log_m):
                for j in range(M):
                    if information[j, k, k1] == j:
                         if encode(information[j,k3,k4]+1,log_m)[k5]==1:
                            pull[j] = k
                         else:
                            pull[j] = (k + 1) % (K)
                    elif information[j,k,k2] == j:
                        pull[j] = k
                    else:
                        pull[j] = (k + 1) % (K)
                for i in range(M):
                    t_total[i,pull[i]]=t_total[i,pull[i]]+1*(1-collision_indicator(i, arm_preference, pull, M))
                    t_total_collision[i, pull[i]] = t_total_collision[i, pull[i]] + 1
                    if k1!=k2:
                     if information[i, k, k2] == i:
                        C[k5] = collision_indicator(i, arm_preference, pull, M)
                        if k5==log_m-1:
                          if decode(C)!=0:
                           information[i, k3, k4] = decode(C)-1
    return information,t_total,t_total_collision
def information_access(arm_preference,M,K,information,t_total,t_total_collision):
    for m in range (M):
     for k in range(K):
        for k1 in range(M):
            for k2 in range(k1+1,M):
               information,t_total,t_total_collision=information_exchange(k1,k2,k,arm_preference,K,M,information,t_total,t_total_collision)
     return information,t_total,t_total_collision
